/* structures for rwts routines */

/* vtoc structure - 256 bytes (1 sector) */
struct vtoc {
char unused;
char ctrack;
char csector;
char version;
char unused2[2];
char volume;
char unused3[32];
char max;
char unused4[8];
char last;
char direction;
char unused5[2];
char tracks;
char sectors;
unsigned bytes;
char bitmap[4][50];
};

/* catalog sector structure - 256 bytes (1 sector) */
struct catsect{
	char unused;
	char track;
	char sector;
	char unused2[8];
	char f1[35];
	char f2[35];
	char f3[35];
	char f4[35];
	char f5[35];
	char f6[35];
	char f7[35];
};

/* file entry structure - 35 bytes */
struct fentry {
char track;
char sector;
char type;
char name[30];
unsigned int sectors;
};

/* number of file entries in each catalog sector */
#define CATENTRIES 7
/* offset to first of 7 file entries in catalog sector */
#define FINDFIRST  0x0b
/* size of each file entry in catalog sector */
#define FINDNEXT    35

/* rwts cmd codes */
#define RWSEEK 0
#define RWREAD 1
#define RWWRITE 2
#define RWFMT 3

/* rwts return codes */
#define RWSUCCESS 0x00
#define RW_IERR   0x08
#define RW_PERR   0x10
#define RW_VERR   0x20
#define RW_DERR   0x40
#define RW_RERR   0x80
/*
$00 = no errors
$08 = error during initialization
$10 = write protect error
$20 = volume mismatch error
$40 = drive error
$80 = read error
*/

